# Generator kluczy publicznego i prywatnego:
# https://www.nostarch.com/crackingcodes/ (na licencji BSD).

import random, sys, os, primeNum, cryptomath


def main():
    # Tworzenie pary kluczy publicznego i prywatnego o wielkości 1024 bitów.
    print('Tworzenie plików kluczy...')
    makeKeyFiles('al_sweigart', 1024)
    print('Pliki kluczy zostały utworzone.')

def generateKey(keySize):
    # Tworzenie pary kluczy publicznego i prywatnego o wielkości keySize wyrażonej w bitach.
    p = 0
    q = 0
    # Krok 1. Tworzenie dwóch liczb pierwszych, p i q, obliczenie wartości n = p * q.
    print('Generowanie liczb pierwszych p oraz q...')
    while p == q:
        p = primeNum.generateLargePrime(keySize)
        q = primeNum.generateLargePrime(keySize)
    n = p * q

    # Krok 2. Tworzenie liczby e, która jest względną liczbą pierwszą dla (p - 1) * (q - 1).
    print('Generowanie liczby e, która jest względną liczbą pierwszą (p - 1) * (q - 1)...')
    while True:
        # Generowanie liczb losowych dla e, dopóki nie otrzymamy prawidłowej.
        e = random.randrange(2 ** (keySize - 1), 2 ** (keySize))
        if cryptomath.gcd(e, (p - 1) * (q - 1)) == 1:
            break

    # Krok 3. Obliczanie liczby d, która jest odwrotnością modularną liczby e.
    print('Obliczanie liczby d, która jest odwrotnością modularną liczby e...')
    d = cryptomath.findModInverse(e, (p - 1) * (q - 1))

    publicKey = (n, e)
    privateKey = (n, d)

    print('Klucz publiczny:', publicKey)
    print('Klucz prywatny:', privateKey)

    return (publicKey, privateKey)


def makeKeyFiles(name, keySize):
    # Tworzenie dwóch plików, 'x_pubkey.txt' i 'x_privkey.txt' (gdzie x to
    # wartość użyta w nazwie), zawierających w treści rozdzielone przecinkiem
    # liczby całkowite n,e i d,e.

    # Zabezpieczenie ma uchronić przed przypadkowym nadpisaniem istniejących plików kluczy.
    if os.path.exists('%s_pubkey.txt' % (name)) or os.path.exists('%s_privkey.txt' % (name)):
        sys.exit('OSTRZEŻENIE! Plik o nazwie %s_pubkey.txt lub %s_privkey.txt już istnieje! Użyj innej nazwy bądź usuń te pliki, a następnie ponownie uruchom program.' % (name, name))

    publicKey, privateKey = generateKey(keySize)

    print()
    print('Klucz publiczny to %s i liczba składająca się z %s cyfr.' % (len(str(publicKey[0])), len(str(publicKey[1]))))
    print('Zapisywanie klucza publicznego do pliku o nazwie %s_pubkey.txt...' % (name))
    fo = open('%s_pubkey.txt' % (name), 'w')
    fo.write('%s,%s,%s' % (keySize, publicKey[0], publicKey[1]))
    fo.close()

    print()
    print('The private key is a %s i liczba składająca się z %s cyfr.' % (len(str(publicKey[0])), len(str(publicKey[1]))))
    print('Zapisywanie klucza prywatnego do pliku o nazwie %s_privkey.txt...' % (name))
    fo = open('%s_privkey.txt' % (name), 'w')
    fo.write('%s,%s,%s' % (keySize, privateKey[0], privateKey[1]))
    fo.close()


# Jeżeli program makePublicPrivateKeys.py został uruchomiony (a nie
# zaimportowany jako moduł), wówczas należy wywołać funkcję main().
if __name__ == '__main__':
    main()
